package view;

import java.awt.GridLayout;
import java.util.Observable;
import java.util.Observer;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

import model.ProxyExecution;

public class TimesPanel extends JPanel implements Observer {

	private static final long serialVersionUID = 1L;
	private ProxyExecution execution;
	private JLabel[] labels = new JLabel[6];

	public TimesPanel(ProxyExecution execution) {
		this.execution = execution;
		execution.addObserver(this);

		setBorder(BorderFactory.createEtchedBorder());
		setLayout(new GridLayout(6, 1));
		setSize(30, UNDEFINED_CONDITION);

		for (int j = 0; j < labels.length; j++) {
			labels[j] = new JLabel("");
			add(labels[j]);
		}

	}

	@Override
	public void update(Observable o, Object arg) {
		for (int i = 0; i < execution.getTimes().length; i++) {
			if (execution.getTimes()[i] != null) {
				labels[i].setText(execution.getTimes()[i]);
			}
			if (!(execution.getActives()[i]))
				labels[i].setVisible(false);
			else if(execution.getActives()[i])
				labels[i].setVisible(true);
		}

	}
}
